/*******************************************************************************
 * Copyright (c) 2000, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.swt.net;


import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class FlickrUtil {
	
public static native String[] getPhotosInfo (Object data) /*{
	var x:XML = new XML(data);
	var length:int = x.photos.photo.length();
	var i:int = 0;
	var result:JavaArray = new JavaArray("java.lang.String").lengths(length * 3);
	for each (var p: XML in x.photos.photo) {
		result[i++] = p.@title.toString();
		result[i++] = p.@id.toString();
		result[i++] = p.@secret.toString();
	}
	return result;	
}*/;

public static native String getPhotoURL(Object data, String size) /*{
	var x:XML = new XML(data);
	var p:XMLList = x.sizes.size.(attribute('label') == size);
	return p.@source.toString();
}*/;

public static void setImage(final Listener listener, String url) {
	Display display = Display.getDefault();
	final Image image = new Image(display, url);
	image.l = new Listener () {
		public void handleEvent(Event event) {
			Event e = new Event();
			e.data = image;
			listener.handleEvent(e);
		}
	};
}

}
